#include <amxmodx>

#define PLUGIN "unique-kz advertisement"
#define VERSION "1.0"
#define AUTHOR "kielor"

#define COLORSNUM 6

new g_pCvar;
new g_szMsg[2048];

new const iColor[COLORSNUM][3] = 
{
	{ 0, 0, 255 },
	{ 0, 255, 0 },
	{ 255, 0, 0 },
	{ 255, 255, 0 },
	{ 0, 255, 255 },
	{ 255, 0, 255 }
}

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	
	register_clcmd("uq_show", "cmdAdvert", -1, "- Shows predefined advertisement message");
	register_clcmd("say /uqteam", "cmdAdvert", -1, "- Shows predefined advertisement message");
	
	g_pCvar = register_cvar("uq_showtime", "10");
}

public plugin_cfg()
{
	new iFile, szBuffer[128], iLen;
	get_localinfo("amxx_configsdir", szBuffer, 127);
	format(szBuffer, 127, "%s/uqmsg.txt", szBuffer);
	
	iFile = fopen(szBuffer, "rt");
	iLen = 0;
	while(!feof(iFile))
	{
		fgets(iFile, szBuffer, 127);
		iLen += format(g_szMsg[iLen], 2047-iLen, "%s", szBuffer);
	}
	fclose(iFile);
}	

public cmdAdvert(id)
{
	static Float:fShowTime, iRandomColor;
	fShowTime = float(get_pcvar_num(g_pCvar));
	iRandomColor = random_num(0, COLORSNUM-1);
	
	set_hudmessage(iColor[iRandomColor][0], iColor[iRandomColor][1], iColor[iRandomColor][2], -1.0, -1.0, 1, 6.0, fShowTime, 0.5, 0.5, -1);
	show_hudmessage(id, g_szMsg);
	
	return PLUGIN_HANDLED;
}