#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fakemeta>
#include <fakemeta_util>
#include <hamsandwich>
#include <kz_stocks>

#pragma semicolon 1

new const PLUGIN[]= "EdgeBug & JumpBug Stats";
new const VERSION[] = "1.5";
new const AUTHOR[] = "newbie & Kpoluk";

// Player Flags
#define PF_None				0
#define PF_Falling			(1 << 0)
#define PF_HasDucked		(1 << 1)
#define PF_DuckReleased		(1 << 2)
#define PF_Jumped			(1 << 3)

new g_iPlayerFlags[33];
new g_iEdgeBugCount[33];

new g_iBeamSprite;

// player settings
new g_EdgeBug[33];
new g_JumpBug[33];
new bool:g_bColorchat[33];
new bool:g_bSound[33];

// eb cvars
new g_pEdgeBugEnabled;
new g_pEdgeBugSound;
new g_pEdgeBugDistanceMin;
new g_pEdgeBugDistanceGood;
new g_pEdgeBugDistancePro;
new g_pEdgeBugDistanceLeet;
new g_pEdgeBugBeam;

// jb cvars
new g_pJumpBugEnabled;
new g_pJumpBugSound;
new g_pJumpBugDistanceMin;
new g_pJumpBugDistanceGood;
new g_pJumpBugDistancePro;
new g_pJumpBugDistanceLeet;

// top cvars
new g_pBugTop;
new g_pBugTopAlone;
new g_pBugTopShowPlace;

new g_iEdgeBug[33];
new g_iJumpBug[33];

new Float:g_flVelocity[33][3];
new Float:g_flFallingFromPoint[33][3];
new Float:g_flJumped[33][3];
new Float:g_flLandingOrigin[33][3];
new Float:g_flCurrentAbsMin[33][3];
new Float:g_flLastAbsMin[33][3][3];

new Float:g_flPrevOrigin[33][3];
new Float:g_flPrevVelocity[33][3];
new Float:g_flEstimDistance[33];

new g_szMapName[34];

new g_iEbTopLocalhost[15];
new g_szEbFile[128];
new g_szEbTopPlayer[15][22];
new g_iEbTopDistance[15];
new g_szEbTopDate[15][22];

new g_iJbTopLocalhost[15];
new g_szJbFile[128];
new g_szJbTopPlayer[15][22];
new g_iJbTopDistance[15];
new g_szJbTopDate[15][22];

new Array:g_aOrigins[33];
new g_iWaitForGoodFrame[33];

#define EPSILON 0.03125

new Float:g_flFrameTime[33];


public plugin_init()
{
	// registering plugin
	register_plugin(PLUGIN, VERSION, AUTHOR);

	// registering cvars
	g_pEdgeBugEnabled		= register_cvar("kz_eb_enable", "1");
	g_pEdgeBugSound			= register_cvar("kz_eb_sound", "1");
	g_pEdgeBugDistanceMin	= register_cvar("kz_eb_min", "150");
	g_pEdgeBugDistanceGood	= register_cvar("kz_eb_good", "1500");
	g_pEdgeBugDistancePro	= register_cvar("kz_eb_pro", "3500");
	g_pEdgeBugDistanceLeet	= register_cvar("kz_eb_leet", "6000");

	g_pEdgeBugBeam			= register_cvar("kz_eb_beam", "1");

	g_pJumpBugEnabled		= register_cvar("kz_jb_enable", "1");
	g_pJumpBugSound			= register_cvar("kz_jb_sound", "1");
	g_pJumpBugDistanceMin	= register_cvar("kz_jb_min", "150");
	g_pJumpBugDistanceGood	= register_cvar("kz_jb_good", "1500");
	g_pJumpBugDistancePro	= register_cvar("kz_jb_pro", "3500");
	g_pJumpBugDistanceLeet	= register_cvar("kz_jb_leet", "6000");
	
	g_pBugTop				= register_cvar("kz_bug_top", "1");
	g_pBugTopAlone			= register_cvar("kz_bug_topalone", "0");
	g_pBugTopShowPlace		= register_cvar("kz_bug_showplace", "1");

	// tops
	new szDir[128];
	get_localinfo("amxx_datadir", szDir, charsmax(szDir));
	format(szDir, charsmax(szDir),"%s/bugtop", szDir);
	if(!dir_exists(szDir))
		mkdir(szDir);

	get_mapname(g_szMapName, charsmax(g_szMapName));

	if(get_pcvar_num(g_pBugTop) > 1)
	{
		format(g_szEbFile, charsmax(g_szEbFile),"%s/edgebug", szDir);
		if(!dir_exists(g_szEbFile))
			mkdir(g_szEbFile);
		format(g_szJbFile, charsmax(g_szJbFile),"%s/jumpbug", szDir);
		if(!dir_exists(g_szJbFile))
			mkdir(g_szJbFile);

		format(g_szEbFile, charsmax(g_szEbFile), "%s/%s.txt", g_szEbFile, g_szMapName);
		format(g_szJbFile, charsmax(g_szJbFile), "%s/%s.txt", g_szJbFile, g_szMapName);
	}
	else
	{
		format(g_szEbFile, charsmax(g_szEbFile), "%s/ebtop.txt", szDir);
		format(g_szJbFile, charsmax(g_szJbFile), "%s/jbtop.txt", szDir);
	}

	readEbTop();
	readJbTop();

	// registering forwards
	RegisterHam(Ham_Touch, "player", "hamPlayerTouch");
	RegisterHam(Ham_Player_PreThink, "player", "hamPlayerPreThink");
	RegisterHam(Ham_Touch, "trigger_teleport", "hamTouch");
	
	// registering commands
	register_saycmd("ebstats", "cmdEbStats");
	register_saycmd("jbstats", "cmdJbStats");
	register_saycmd("bugcolorchat",	"cmdColorChat");
	register_saycmd("colorchatbug",	"cmdColorChat");
	register_saycmd("bugsound", "cmdBugSound");
	register_saycmd("soundbug", "cmdBugSound");

	register_saycmd("jbtrainer", "cmdJbTrainer");

	register_saycmd("ebtop", "cmdShowEbTop");
	register_saycmd("ebtop10", "cmdShowEbTop");
	register_saycmd("ebtop15", "cmdShowEbTop");
	register_saycmd("eb10", "cmdShowEbTop");
	register_saycmd("eb15", "cmdShowEbTop");

	register_saycmd("jbtop", "cmdShowJbTop");
	register_saycmd("jbtop10", "cmdShowJbTop");
	register_saycmd("jbtop15", "cmdShowJbTop");
	register_saycmd("jb10", "cmdShowJbTop");
	register_saycmd("jb15", "cmdShowJbTop");

	for(new id = 0; id < 33; id++)
	{
		g_aOrigins[id] = ArrayCreate(1);
		g_iWaitForGoodFrame[id] = 0;

		g_flFrameTime[id] = 0.01;
	}

	register_forward(FM_CmdStart, "fwCmdStart");
}

public fwCmdStart(id, uc_handle)
{
	if(is_user_bot(id))
		return;

	g_flFrameTime[id] = get_uc(uc_handle, UC_Msec) / 1000.0;
}

public plugin_end()
{
	for(new id = 0; id < 33; id++)
		ArrayDestroy(g_aOrigins[id]);
}

public plugin_precache()
{
	g_iBeamSprite = precache_model("sprites/zbeam4.spr");
	
	precache_sound("misc/mod_godlike.wav");
	precache_sound("misc/mod_wickedsick.wav");
	precache_sound("misc/perfect.wav");
	precache_sound("misc/impressive.wav");
	precache_sound("misc/double.wav");
	precache_sound("misc/triple.wav");
	precache_sound("misc/holyshit.wav");
}

public plugin_cfg()
{
	new szConfigsDir[128];
	get_configsdir(szConfigsDir, charsmax(szConfigsDir));
	format(szConfigsDir, charsmax(szConfigsDir), "%s/kz_bug_stats.cfg", szConfigsDir);
	
	if(file_exists(szConfigsDir))
	{
		server_cmd("exec %s", szConfigsDir);
		server_exec();
	}
}

public client_connect(id)
{
	g_iPlayerFlags[id] = PF_None;
	g_iEdgeBugCount[id] = 0;

	g_EdgeBug[id] = get_pcvar_num(g_pEdgeBugEnabled);
	g_JumpBug[id] = get_pcvar_num(g_pJumpBugEnabled);
	g_bColorchat[id] = true;
	g_bSound[id] = true;

	g_iEdgeBug[id] = 0;
	g_iJumpBug[id] = 0;

	copy_vector(VEC_NULL, g_flVelocity[id]);

	copy_vector(VEC_NULL, g_flFallingFromPoint[id]);
	copy_vector(VEC_NULL, g_flJumped[id]);
	copy_vector(VEC_NULL, g_flLandingOrigin[id]);

	copy_vector(VEC_NULL, g_flPrevOrigin[id]);
	copy_vector(VEC_NULL, g_flPrevVelocity[id]);
	g_flEstimDistance[id] = 0.0;
}

public fwResetBug(id) // forward
{
	clear(id);
}

public hamTouch(ent, id)
{
	if(is_user_bot(id))
		return HAM_IGNORED;

	if(!is_user_alive(id))
		return HAM_IGNORED;

	clear(id);

	return HAM_IGNORED;
}

public hamPlayerTouch(id, ent)
{
	if(is_user_bot(id))
		return HAM_IGNORED;

	new Float:flVelocity[3];
	pev(id, pev_velocity, flVelocity);
	
	if(flVelocity[2] > 0.0)
		return HAM_IGNORED;
	
	if(!(g_iPlayerFlags[id] & PF_Falling) || pev(id, pev_flags) & FL_ONGROUND)
		return HAM_IGNORED;
	
	pev(id, pev_absmin, g_flCurrentAbsMin[id]);
	if(floatround(g_flCurrentAbsMin[id][2], floatround_floor) != g_flCurrentAbsMin[id][2] - EPSILON)
		return HAM_IGNORED;

	if(is_player_sliding(id))
		return HAM_IGNORED;
	
	g_iEdgeBug[id] = 1;
	
	return HAM_IGNORED;
}

public hamPlayerPreThink(id)
{
	if(is_user_bot(id))
		return HAM_IGNORED;

	if(!is_user_alive(id))
	{
		ArrayClear(g_aOrigins[id]);
		return HAM_IGNORED;
	}
	
	// incorrect cvars
	new Float:fGravity;
	pev(id, pev_gravity, fGravity);
	
	if(fGravity != 1.0 || get_cvar_num("sv_gravity") != 800 || get_cvar_num("sv_maxvelocity") != 2000)
	{
		clear(id);
		return HAM_IGNORED;
	}


	copy_vector(g_flLastAbsMin[id][1], g_flLastAbsMin[id][2]);
	copy_vector(g_flLastAbsMin[id][0], g_flLastAbsMin[id][1]);
	pev(id, pev_absmin, g_flLastAbsMin[id][0]);


	new flags = pev(id, pev_flags);
	
	// water
	if(flags & FL_INWATER && pev(id, pev_waterlevel) >= 2)
	{
		ArrayClear(g_aOrigins[id]);
		clear(id);
		return HAM_IGNORED;
	}
	
	// ladder
	if(pev(id, pev_movetype) == MOVETYPE_FLY)
	{
		ArrayClear(g_aOrigins[id]);
		clear(id);
		return HAM_IGNORED;
	}

	// detect teleport
	pev(id, pev_velocity, g_flVelocity[id]);

	new Float:flOrigin[3];
	pev(id, pev_origin, flOrigin);

	if(!is_zero_vec(g_flPrevOrigin[id]) && is_zero_vec(g_flVelocity[id]))
	{
		new Float:flPassedDistance = floatsqroot((flOrigin[0] - g_flPrevOrigin[id][0]) * (flOrigin[0] - g_flPrevOrigin[id][0]) + 
									(flOrigin[1] - g_flPrevOrigin[id][1]) * (flOrigin[1] - g_flPrevOrigin[id][1]) + 
									(flOrigin[2] - g_flPrevOrigin[id][2]) * (flOrigin[2] - g_flPrevOrigin[id][2]));

		if(flPassedDistance > 19.0)
			clear(id);
	}	

	// save new height
	if(ArraySize(g_aOrigins[id]) >= 40)
		ArrayDeleteItem(g_aOrigins[id], 0);
	ArrayPushCell(g_aOrigins[id], flOrigin[2]);
	
	// check for bugs
	if(g_EdgeBug[id] || g_bColorchat[id])
	{
		if(g_iEdgeBug[id])
			checkEdgeBug(id);
	}

	if(g_JumpBug[id] || g_bColorchat[id])
	{
		if(g_JumpBug[id] > 1)
		{
			if(g_iWaitForGoodFrame[id] > 0)
				findGoodFrame(id); // waiting for good frame, no jb check
			else
				traceJumpBug(id);
		}
		else
		{
			if(g_iJumpBug[id])
				checkJumpBug(id);
			else
				traceJumpBug(id);
		}
	}
	
	if(flags & FL_ONGROUND && (g_iPlayerFlags[id] & PF_Falling))
		clear(id);
	
	new buttons = pev(id, pev_button);
	new oldbuttons = pev(id, pev_oldbuttons);
	
	// falling start...
	if(!(flags & FL_ONGROUND) && !(flags & FL_INWATER) && !(g_iPlayerFlags[id] & PF_Falling))
	{
		g_iPlayerFlags[id] |= PF_Falling;
		pev(id, pev_origin, g_flFallingFromPoint[id]);
	}
	
	// save duck's release state
	if((g_iPlayerFlags[id] & PF_Falling) && oldbuttons & IN_DUCK && !(buttons & IN_DUCK))
	{
		g_iPlayerFlags[id] |= PF_DuckReleased;
	}

	copy_vector(flOrigin, g_flPrevOrigin[id]);
	copy_vector(g_flVelocity[id], g_flPrevVelocity[id]);
	
	return HAM_IGNORED;
}

public traceJumpBug(id)
{	
	if(pev(id, pev_flags) & FL_ONGROUND)
		return;
	
	if((pev(id, pev_oldbuttons) & IN_JUMP) || !(pev(id, pev_button) & IN_JUMP))
		return;
	
	if(!(pev(id, pev_oldbuttons) & IN_DUCK) || (pev(id, pev_button) & IN_DUCK))
		return;
	
	if(g_flVelocity[id][2] >= 0.0)
		return;

	pev(id, pev_origin, g_flJumped[id]);

	if(g_JumpBug[id] < 2)
		g_iJumpBug[id] = 2;
	else
		checkJumpBugDetailed(id);
}

public checkJumpBugDetailed(id)
{
	g_flLandingOrigin[id][0] = g_flJumped[id][0];
	g_flLandingOrigin[id][1] = g_flJumped[id][1];
	g_flLandingOrigin[id][2] = float(floatround(g_flJumped[id][2], floatround_floor));
	
	if(fm_trace_hull(g_flLandingOrigin[id], HULL_HUMAN, id)) // instant stuck -> too low
	{
		new iCounter = 18; // just to be safe
		while(!fm_trace_hull(g_flLandingOrigin[id], HULL_HEAD, id) && iCounter > 0) // trace in duck
		{
			g_flLandingOrigin[id][2] -= 1.0;
			iCounter--;
		}
		
		if(iCounter <= 0) // impossible
			return;

		g_flLandingOrigin[id][2] = g_flLandingOrigin[id][2] + 18.0 + 1.0; // 36 units above the ground

		new Float:flDistance = g_flFallingFromPoint[id][2] - g_flLandingOrigin[id][2];
		if(flDistance < get_pcvar_float(g_pJumpBugDistanceMin))
			return;

		new Float:flUnitsUnder = g_flJumped[id][2] - 36.0 - g_flLandingOrigin[id][2];

		if(flUnitsUnder >= 0.0)
			return; // something went wrong

		if(ArraySize(g_aOrigins[id]) < 40)
			return; // not enough origins

		new iFramesShift = 1;

		new pos = 38; // last height
		new Float:flCorrOrigin = Float:ArrayGetCell(g_aOrigins[id], pos);

		flUnitsUnder = flCorrOrigin - g_flLandingOrigin[id][2];

		while(flUnitsUnder < 0.0) // still too late, let's take one frame before
		{
			pos--;
			if(pos < 1)
				return; // shouldn't be
			flCorrOrigin = Float:ArrayGetCell(g_aOrigins[id], pos);
			flUnitsUnder = flCorrOrigin - g_flLandingOrigin[id][2];

			iFramesShift++;
		}

		if(flUnitsUnder > 2.0)
			jumpBugNotPoss(id, flDistance, g_flJumped[id][2], g_flLandingOrigin[id][2], flCorrOrigin, iFramesShift, Float:ArrayGetCell(g_aOrigins[id], pos + 1), iFramesShift - 1, true); // oh no now we're too low
		else
			jumpBugFailed(id, flDistance, g_flJumped[id][2], g_flLandingOrigin[id][2], flCorrOrigin, iFramesShift, true); // finally found good position
	}
	else
	{
		new iCounter = floatround(-g_flVelocity[id][2] * g_flFrameTime[id] * 7.0, floatround_floor); // about 7 frames higher

		while(!fm_trace_hull(g_flLandingOrigin[id], HULL_HUMAN, id) && iCounter > 0) // trace no duck
		{
			g_flLandingOrigin[id][2] -= 1.0;
			iCounter--;
		}
		
		if(iCounter <= 0) // too high
			return;

		g_flLandingOrigin[id][2] = g_flLandingOrigin[id][2] + 1.0; // 36 units above the ground

		new Float:flDistance = g_flFallingFromPoint[id][2] - g_flLandingOrigin[id][2];
		if(flDistance < get_pcvar_float(g_pJumpBugDistanceMin))
			return;

		new Float:flUnitsAbove = g_flJumped[id][2] - g_flLandingOrigin[id][2];

		if(flUnitsAbove <= 0.0)
			return; // something went wrong

		if(flUnitsAbove > 2.0)
			g_iWaitForGoodFrame[id] = 40; // wait for it
		else
			jumpBugSuccessful(id, flDistance, g_flJumped[id][2], g_flLandingOrigin[id][2]);
	}		
}

public findGoodFrame(id)
{
	g_iWaitForGoodFrame[id]--;
	if(g_iWaitForGoodFrame[id] == 0)
		return; // waiting too long

	if(ArraySize(g_aOrigins[id]) < 40)
		return; // not enough origins

	new Float:flDistance = g_flFallingFromPoint[id][2] - g_flLandingOrigin[id][2];

	new iFramesShift = 40 - g_iWaitForGoodFrame[id];

	new pos = 39; // last height
	new Float:flCorrOrigin = Float:ArrayGetCell(g_aOrigins[id], pos);
	
	if(pev(id, pev_flags) & FL_ONGROUND) // ground
	{
		g_iWaitForGoodFrame[id] = 0;

		new Float:flPrevOrigin = Float:ArrayGetCell(g_aOrigins[id], pos - 1);

		// prediction (prethink called at the moment when Velocity[2] is + (400 * frametime) from what it should be for calculating new origin)
		new Float:flPredictedOrigin = flPrevOrigin + (g_flPrevVelocity[id][2] - 400.0 * g_flFrameTime[id]) * g_flFrameTime[id];

		if(flPredictedOrigin < flCorrOrigin)
			jumpBugNotPoss(id, flDistance, g_flJumped[id][2], g_flLandingOrigin[id][2], flPrevOrigin, iFramesShift - 1, flCorrOrigin, 999, false); // 999 ground (falling too fast, skipping 2 units near the ground)
		else
			jumpBugFailed(id, flDistance, g_flJumped[id][2], g_flLandingOrigin[id][2], flPredictedOrigin, iFramesShift, false);

//		return;
	}

/*
	new Float:flUnitsAbove = flCorrOrigin - g_flLandingOrigin[id][2];

	if(flUnitsAbove < 2.0)
	{
		client_print(id, print_chat, "WRONG flUnitsAbove %f", flUnitsAbove);

		if(flUnitsAbove < 0.0)
			jumpBugNotPoss(id, flDistance, g_flJumped[id][2], g_flLandingOrigin[id][2], Float:ArrayGetCell(g_aOrigins[id], pos - 1), iFramesShift - 1, flCorrOrigin, iFramesShift, false); // now we're too low (shouldn't be possible)
		else
			jumpBugFailed(id, flDistance, g_flJumped[id][2], g_flLandingOrigin[id][2], flCorrOrigin, iFramesShift, false); // finally found good position (shouldn't be possible cause teleport near the ground)

		g_iWaitForGoodFrame[id] = 0;
	}
*/
}

public jumpBugNotPoss(id, Float:flDistance, Float:flMyZ, Float:flRequiredZ, Float:flNearestZ1, iFramesShift1, Float:flNearestZ2, iFramesShift2, bool:bLater)
{
	new szMessage1[500], szMessage2[500], szMessage3[500];

	if(bLater)
		formatex(szMessage1, charsmax(szMessage1), "Impossible JumpBug^nDistance: %.2f units^nLower by: %.2f units", flDistance, flRequiredZ - flMyZ);
	else
		formatex(szMessage1, charsmax(szMessage1), "Impossible JumpBug^nDistance: %.2f units^nHigher by: %.2f units", flDistance, flMyZ - flRequiredZ);

	set_hudmessage(255, 0, 255, -1.0, 0.75, 0, 0.0, 3.0, 0.1, 0.1, 4);
	show_hudmessage(id, "%s", szMessage1);

	formatex(szMessage2, charsmax(szMessage2), "Your Z: %.6f^nRequired Z: %.6f (+ 2.0)", flMyZ, flRequiredZ);

	new szNearest1[50], szNearest2[50];

	if(bLater)
	{
		formatex(szNearest1, charsmax(szNearest1), "%d frame%s earlier", iFramesShift1, iFramesShift1 > 1 ? "s" : "");

		if(iFramesShift2 == 0)
			formatex(szNearest2, charsmax(szNearest2), "same frame");
		else
			formatex(szNearest2, charsmax(szNearest2), "%d frame%s earlier", iFramesShift2, iFramesShift2 > 1 ? "s" : "");

		formatex(szMessage3, charsmax(szMessage3), "Nearest Z1: %.6f (%s)^nNearest Z2: %.6f (%s)", flNearestZ1, szNearest1, flNearestZ2, szNearest2);
	}
	else
	{
		if(iFramesShift1 == 0)
			formatex(szNearest1, charsmax(szNearest1), "same frame");
		else
			formatex(szNearest1, charsmax(szNearest1), "%d frame%s later", iFramesShift1, iFramesShift1 > 1 ? "s" : "");

		if(iFramesShift2 == 999)
			formatex(szNearest2, charsmax(szNearest2), "ground");
		else
			formatex(szNearest2, charsmax(szNearest2), "%d frame%s later", iFramesShift2, iFramesShift2 > 1 ? "s" : "");

		formatex(szMessage3, charsmax(szMessage3), "Nearest Z1: %.6f (%s)^nNearest Z2: %.6f (%s)", flNearestZ1, szNearest1, flNearestZ2, szNearest2);
	}

	client_print(id, print_console, szMessage1);
	client_print(id, print_console, szMessage2);
	client_print(id, print_console, szMessage3);
}


public jumpBugFailed(id, Float:flDistance, Float:flMyZ, Float:flRequiredZ, Float:flPossibleZ, iFramesShift, bool:bLater)
{
	new szMessage1[500], szMessage2[500];

	if(bLater)
	{
		formatex(szMessage1, charsmax(szMessage1), "Failed JumpBug^nDistance: %.2f units^n%d frame%s later^nLower by: %.2f units", flDistance, iFramesShift, iFramesShift > 1 ? "s" : "", flRequiredZ - flMyZ);
		formatex(szMessage2, charsmax(szMessage2), "Your Z: %.6f^nRequired Z: %.6f (+ 2.0)^nPossible Z: %.6f (%d frame%s earlier)", flMyZ, flRequiredZ, flPossibleZ, iFramesShift, iFramesShift > 1 ? "s" : "");
	}
	else
	{
		formatex(szMessage1, charsmax(szMessage1), "Failed JumpBug^nDistance: %.2f units^n%d frame%s earlier^nHigher by: %.2f units", flDistance, iFramesShift, iFramesShift > 1 ? "s" : "", flMyZ - flRequiredZ);
		formatex(szMessage2, charsmax(szMessage2), "Your Z: %.6f^nRequired Z: %.6f (+ 2.0)^nPossible Z: %.6f (%d frame%s later)", flMyZ, flRequiredZ, flPossibleZ, iFramesShift, iFramesShift > 1 ? "s" : "");
	}

	set_hudmessage(255, 0, 0, -1.0, 0.75, 0, 0.0, 3.0, 0.1, 0.1, 4);
	show_hudmessage(id, "%s", szMessage1);

	client_print(id, print_console, szMessage1);
	client_print(id, print_console, szMessage2);
}

public jumpBugSuccessful(id, Float:flDistance, Float:flMyZ, Float:flRequiredZ)
{
	new szMessage1[500], szMessage2[500];

	formatex(szMessage1, charsmax(szMessage1), "JumpBug^nDistance: %.2f units^nLeft: %.2f units", flDistance, flMyZ - flRequiredZ);

	formatex(szMessage2, charsmax(szMessage2), "Your Z: %.6f^nRequired Z: %.6f (+ 2.0)", flMyZ, flRequiredZ);

	set_hudmessage(0, 255, 0, -1.0, 0.75, 0, 0.0, 3.0, 0.1, 0.1, 4);
	show_hudmessage(id, szMessage1);

	client_print(id, print_console, szMessage1);
	client_print(id, print_console, szMessage2);

	jumpBugSoundAndTop(id, flDistance);
}

public checkJumpBug(id)
{
	if(g_iJumpBug[id])
	{
		g_iJumpBug[id]--;
		if(g_iJumpBug[id])
			return;
	}

	if(g_flVelocity[id][2] <= 0.0)
		return;
	
	g_flLandingOrigin[id][0] = g_flJumped[id][0];
	g_flLandingOrigin[id][1] = g_flJumped[id][1];
	g_flLandingOrigin[id][2] = float(floatround(g_flJumped[id][2], floatround_floor));
	
	while(!fm_trace_hull(g_flLandingOrigin[id], HULL_HUMAN, id))
		g_flLandingOrigin[id][2] -= 1.0;
	
	g_flLandingOrigin[id][2] = g_flLandingOrigin[id][2] + 1.0;

	new Float:distance = g_flFallingFromPoint[id][2] - g_flLandingOrigin[id][2];
	if(distance < get_pcvar_float(g_pJumpBugDistanceMin))
		return;

	new Float:flUnitsAbove = g_flJumped[id][2] - g_flLandingOrigin[id][2];

	jumpBugDone(id, distance, flUnitsAbove);
}

public jumpBugDone(id, Float:flDistance, Float:fUnitsLeft)
{
	new iDistance = floatround(flDistance, floatround_floor);
	
	if(g_JumpBug[id] > 0)
	{
		set_hudmessage(0, 255, 0, -1.0, 0.75, 0, 0.0, 2.0, 0.1, 0.1, 4);
		show_hudmessage(id, "JumpBug: %d units^nLeft: %.2f units^nWell done!", iDistance, fUnitsLeft);
		client_print(id, print_console, "JumpBug: %d units^nLeft: %.6f units^nWell done!", iDistance, fUnitsLeft);
	}
	
	jumpBugSoundAndTop(id, flDistance);
}

public jumpBugSoundAndTop(id, Float:flDistance)
{
	new iDistance = floatround(flDistance, floatround_floor);

	new name[33];
	get_user_name(id, name, charsmax(name));

	new players[32], num, plr;
	get_players(players, num);

	for(new i = 0; i < num; i++)
	{
		plr = players[i];

		if(g_bColorchat[plr])
		{
			if(flDistance >= get_pcvar_float(g_pJumpBugDistanceLeet))
			{
				client_print_f(plr, RED, "[KZ] %s has done %d units with JumpBug", name, iDistance);
				
				if(get_pcvar_num(g_pJumpBugSound) && g_bSound[plr])
				{
					if(id == plr)
						client_cmd(id, "speak misc/mod_wickedsick");
					else
						client_cmd(plr, "speak misc/mod_godlike");
				}
			}
			else if(flDistance >= get_pcvar_float(g_pJumpBugDistancePro))
			{
				client_print_f(plr, GREEN, "[KZ] %s has done %d units with JumpBug", name, iDistance);
				
				if(get_pcvar_num(g_pJumpBugSound) && g_bSound[plr])
					client_cmd(id, "speak misc/perfect");
			}
			else if(flDistance >= get_pcvar_float(g_pJumpBugDistanceGood))
			{
				client_print_f(plr, GREY, "[KZ] %s has done %d units with JumpBug", name, iDistance);
				
				if(get_pcvar_num(g_pJumpBugSound) && g_bSound[plr])
					client_cmd(id, "speak misc/impressive");
			}
		}
	}

	if(get_pcvar_num(g_pBugTop) && (is_user_localhost(id) || get_pcvar_num(g_pBugTopAlone) == 0))
		setJbTop(id, iDistance);
}

public checkEdgeBug(id)
{
	if(g_iEdgeBug[id])
		g_iEdgeBug[id] = 0;

	if(g_flVelocity[id][2] < 0.0 && g_flVelocity[id][2] >= -20.0)
	{		
		g_flCurrentAbsMin[id][0] += 16.0;
		g_flCurrentAbsMin[id][1] += 16.0;
		g_flCurrentAbsMin[id][2] += 0.96875;
		
		g_flLastAbsMin[id][2][0] += 16.0;
		g_flLastAbsMin[id][2][1] += 16.0;
		g_flLastAbsMin[id][2][2] += 0.96875;
		
		new Float:flEdgeOrigin[3];
		flEdgeOrigin[0] = (g_flLastAbsMin[id][2][0] + g_flCurrentAbsMin[id][0]) / 2;
		flEdgeOrigin[1] = (g_flLastAbsMin[id][2][1] + g_flCurrentAbsMin[id][1]) / 2;
		flEdgeOrigin[2] = g_flCurrentAbsMin[id][2];
				
		new Float:distance = g_flFallingFromPoint[id][2] - flEdgeOrigin[2];
		
		if(distance >= get_pcvar_float(g_pEdgeBugDistanceMin))
		{
			if(get_pcvar_num(g_pEdgeBugBeam))
			{
				fnDrawLine(id, flEdgeOrigin[0] - 16.0, flEdgeOrigin[1] - 16.0, flEdgeOrigin[2], flEdgeOrigin[0] - 16.0, flEdgeOrigin[1] + 16.0, flEdgeOrigin[2], {0, 255, 0});
				fnDrawLine(id, flEdgeOrigin[0] - 16.0, flEdgeOrigin[1] - 16.0, flEdgeOrigin[2], flEdgeOrigin[0] + 16.0, flEdgeOrigin[1] - 16.0, flEdgeOrigin[2], {0, 255, 0});
				fnDrawLine(id, flEdgeOrigin[0] + 16.0, flEdgeOrigin[1] - 16.0, flEdgeOrigin[2], flEdgeOrigin[0] + 16.0, flEdgeOrigin[1] + 16.0, flEdgeOrigin[2], {0, 255, 0});
				fnDrawLine(id, flEdgeOrigin[0] + 16.0, flEdgeOrigin[1] + 16.0, flEdgeOrigin[2], flEdgeOrigin[0] - 16.0, flEdgeOrigin[1] + 16.0, flEdgeOrigin[2], {0, 255, 0});
			}

			g_iEdgeBugCount[id]++;

			edgeBugDone(id, distance, g_iEdgeBugCount[id]);
		}
	}
}

public edgeBugDone(id, Float:flDistance, count)
{
	new name[33];
	get_user_name(id, name, charsmax(name));
	
	new iDistance = floatround(flDistance, floatround_floor);
	
	if(g_EdgeBug[id])
	{
		set_hudmessage(0, 255, 0, -1.0, 0.75, 0, 0.0, 2.0, 0.1, 0.1, 4);
		show_hudmessage(id, "Fall Distance: %d^nWell done!", iDistance);
		client_print(id, print_console, "Fall Distance: %d^nWell done!", iDistance);
	}

	new players[32], num, plr;
	get_players(players, num);

	for(new i = 0; i < num; i++)
	{
		plr = players[i];
		
		if(g_bColorchat[plr])
		{
			if(count > 3)
			{
				client_print_f(plr, BLUE, "[KZ] %s has done %d EdgeBugs in a row (%d units)", name, count, iDistance);
				
				if(get_pcvar_num(g_pEdgeBugSound) && g_bSound[plr])
					client_cmd(plr, "speak misc/holyshit");
			}
			else if(count == 3)
			{
				client_print_f(plr, BLUE, "[KZ] %s has done 3 EdgeBugs in a row (%d units)", name, iDistance);
				
				if(get_pcvar_num(g_pEdgeBugSound) && g_bSound[plr])
					client_cmd(plr, "speak misc/triple");
			}
			else if(count == 2)
			{
				client_print_f(plr, RED, "[KZ] %s has done 2 EdgeBugs in a row (%d units)", name, iDistance);
				
				if(get_pcvar_num(g_pEdgeBugSound) && g_bSound[plr])
					client_cmd(plr, "speak misc/double");
			}
			else if(flDistance >= get_pcvar_float(g_pEdgeBugDistanceLeet))
			{
				client_print_f(plr, RED, "[KZ] %s has done %d units with EdgeBug", name, iDistance);
				
				if(get_pcvar_num(g_pEdgeBugSound) && g_bSound[plr])
				{
					if(id == plr)
						client_cmd(id, "speak misc/mod_wickedsick");
					else
						client_cmd(plr, "speak misc/mod_godlike");
				}
			}
			else if(flDistance >= get_pcvar_float(g_pEdgeBugDistancePro))
			{
				client_print_f(plr, GREEN, "[KZ] %s has done %d units with EdgeBug", name, iDistance);
				
				if(get_pcvar_num(g_pEdgeBugSound) && g_bSound[plr])
					client_cmd(id, "speak misc/perfect");
			}
			else if(flDistance >= get_pcvar_float(g_pEdgeBugDistanceGood))
			{
				client_print_f(plr, GREY, "[KZ] %s has done %d units with EdgeBug", name, iDistance);
				
				if(get_pcvar_num(g_pEdgeBugSound) && g_bSound[plr])
					client_cmd(id, "speak misc/impressive");
			}
		}
	}

	if(get_pcvar_num(g_pBugTop) && (is_user_localhost(id) || get_pcvar_num(g_pBugTopAlone) == 0))
		setEbTop(id, iDistance);
}

public cmdJbStats(id)
{
	if(g_JumpBug[id])
	{
		client_print_f(id, RED, "^x04[KZ]^x01 JumpBug Stats and Trainer have been^x03 disabled");
		g_JumpBug[id] = 0;
	}
	else
	{
		client_print_f(id, BLUE, "^x04[KZ]^x01 JumpBug Stats has been^x03 enabled^x01. To enable Trainer, say^x04 /jbtrainer");
		g_JumpBug[id] = 1;
	}
	
	return PLUGIN_HANDLED;
}

public cmdJbTrainer(id)
{
	if(g_JumpBug[id] == 2)
	{
		client_print_f(id, RED, "^x04[KZ]^x01 JumpBug Trainer has been^x03 disabled");
		g_JumpBug[id] = 1;
	}
	else if(g_JumpBug[id] == 1)
	{
		client_print_f(id, BLUE, "^x04[KZ]^x01 JumpBug Trainer has been^x03 enabled");
		g_JumpBug[id] = 2;
	}
	else
	{
		client_print_f(id, BLUE, "^x04[KZ]^x01 JumpBug Stats and Trainer have been^x03 enabled^x01");
		g_JumpBug[id] = 2;
	}
	
	return PLUGIN_HANDLED;
}

public cmdEbStats(id)
{
	if(g_EdgeBug[id])
	{
		client_print_f(id, RED, "^x04[KZ]^x01 EdgeBug Stats has been^x03 disabled");
		g_EdgeBug[id] = 0;
	}
	else
	{
		client_print_f(id, BLUE, "^x04[KZ]^x01 EdgeBug Stats has been^x03 enabled");
		g_EdgeBug[id] = 1;
	}
	
	return PLUGIN_HANDLED;
}

public cmdColorChat(id)
{
	if(g_bColorchat[id])
		client_print_f(id, RED, "^x04[KZ]^x01 Bugs Colorchat has been^x03 disabled");
	else
		client_print_f(id, BLUE, "^x04[KZ]^x01 Bugs Colorchat Stats has been^x03 enabled");

	g_bColorchat[id] = !g_bColorchat[id];
	
	return PLUGIN_HANDLED;
}

public cmdBugSound(id)
{	
	if(g_bSound[id])
		client_print_f(id, RED, "^x04[KZ]^x01 Bug Sounds have been^x03 disabled");
	else
		client_print_f(id, BLUE, "^x04[KZ]^x01 Bugs Sounds has been^x03 enabled");

	g_bSound[id] = !g_bSound[id];
	
	return PLUGIN_HANDLED;	
}

public clear(id)
{
	g_iPlayerFlags[id] = PF_None;
	g_iEdgeBugCount[id] = 0;
}

stock fnDrawLine(id, Float:x1, Float:y1, Float:z1, Float:x2, Float:y2, Float:z2, g_iColor[3])
{
	message_begin(id ? MSG_ONE_UNRELIABLE : MSG_BROADCAST, SVC_TEMPENTITY, _, id ? id : 0);
	write_byte(TE_BEAMPOINTS);
	write_coord(floatround(x1));
	write_coord(floatround(y1));
	write_coord(floatround(z1));
	write_coord(floatround(x2));
	write_coord(floatround(y2));
	write_coord(floatround(z2));
	write_short(g_iBeamSprite);
	write_byte(1);
	write_byte(1);
	write_byte(200);
	write_byte(5);
	write_byte(0);
	write_byte(g_iColor[0]);
	write_byte(g_iColor[1]);
	write_byte(g_iColor[2]);
	write_byte(255);
	write_byte(0);
	message_end();
}

stock bool:is_in_duck(entity)
{
	if(!pev_valid(entity))
		return false;
	
	static Float:absmin[3], Float:absmax[3];
	
	pev(entity, pev_absmin, absmin);
	pev(entity, pev_absmax, absmax);
	
	if(absmin[2] + 64.0 < absmax[2])
		return false;
	
	return true;
}

public readEbTop()
{
	if(file_exists(g_szEbFile)) 
	{
		new szData[512], handle = fopen(g_szEbFile, "rt"), szLocalhost[5], szDistance[22];	
		for(new i = 0; i < 15; i++)
		{
			fgets(handle, szData, charsmax(szData));
			trim(szData);
			if(szData[0])
			{
				parse(szData, szLocalhost, charsmax(szLocalhost), g_szEbTopPlayer[i], charsmax(g_szEbTopPlayer[]), szDistance, charsmax(szDistance), g_szEbTopDate[i], charsmax(g_szEbTopDate[]));
				g_iEbTopLocalhost[i] = str_to_num(szLocalhost);
				g_iEbTopDistance[i] = str_to_num(szDistance);
			}
			else
			{
				g_iEbTopLocalhost[i] = 0;
				g_szEbTopPlayer[i][0] = 0;
				g_iEbTopDistance[i] = 0;
				g_szEbTopDate[i][0] = 0;
			}
		}
		fclose(handle);
	}
}

public readJbTop()
{
	if(file_exists(g_szJbFile)) 
	{
		new szData[512], handle = fopen(g_szJbFile, "rt"), szLocalhost[5], szDistance[22];	
		for(new i = 0; i < 15; i++)
		{
			fgets(handle, szData, charsmax(szData));
			trim(szData);
			if(szData[0])
			{
				parse(szData, szLocalhost, charsmax(szLocalhost), g_szJbTopPlayer[i], charsmax(g_szJbTopPlayer[]), szDistance, charsmax(szDistance), g_szJbTopDate[i], charsmax(g_szJbTopDate[]));
				g_iJbTopLocalhost[i] = str_to_num(szLocalhost);
				g_iJbTopDistance[i] = str_to_num(szDistance);
			}
			else
			{
				g_iJbTopLocalhost[i] = 0;
				g_szJbTopPlayer[i][0] = 0;
				g_iJbTopDistance[i] = 0;
				g_szJbTopDate[i][0] = 0;
			}
		}
		fclose(handle);
	}
}

stock setEbTop(id, iDistance)
{
	new iPlaceInTop = 0;

	for(new i = 0; i < 15; i++)
	{
		if(g_iEbTopDistance[i] == 0 || iDistance > g_iEbTopDistance[i])
			break;
		iPlaceInTop++;
	}

	if(iPlaceInTop < 15)
	{
		new szData[512], handle = fopen(g_szEbFile, "wt");	
		for(new j = 14; j > iPlaceInTop; j--)
		{
			g_iEbTopLocalhost[j] = g_iEbTopLocalhost[j-1];
			format(g_szEbTopPlayer[j], charsmax(g_szEbTopPlayer[]), "%s", g_szEbTopPlayer[j-1]);
			g_iEbTopDistance[j] = g_iEbTopDistance[j-1];
			format(g_szEbTopDate[j], charsmax(g_szEbTopDate[]), "%s", g_szEbTopDate[j-1]);
		}

		new curr_time[22]; 
		get_time("%d/%m/%Y", curr_time, charsmax(curr_time)); 
		
		new name[22];
		get_user_name(id, name, charsmax(name));

		if(get_pcvar_num(g_pBugTopShowPlace))
			client_print_f(id, BLUE, "^x04[KZ]^x01 %s's jump is on^x03 %d place^x01 in EdgeBug Top!", name, iPlaceInTop + 1);
		
		replace_all(name, charsmax(name), "<", ""); 
		replace_all(name, charsmax(name), ">", "");
		replace_all(name, charsmax(name), "^"", ""); //"
		replace_all(name, charsmax(name), " ", "_");
		replace_all(name, charsmax(name), ";", ""); 		

		g_iEbTopLocalhost[iPlaceInTop] = is_user_localhost(id);
		formatex(g_szEbTopPlayer[iPlaceInTop], charsmax(g_szEbTopPlayer[]), "%s", name);
		g_iEbTopDistance[iPlaceInTop] = iDistance;
		formatex(g_szEbTopDate[iPlaceInTop], charsmax(g_szEbTopDate[]), "%s", curr_time);

		for(new i = 0; (i < 15 && g_iEbTopDistance[i] > 0); i++)
		{
			formatex(szData, charsmax(szData), "%d %s %d %s^n", g_iEbTopLocalhost[i], g_szEbTopPlayer[i], g_iEbTopDistance[i], g_szEbTopDate[i]);
			fputs(handle, szData);
		}

		fclose(handle);
	}
}

stock setJbTop(id, iDistance)
{
	new iPlaceInTop = 0;

	for(new i = 0; i < 15; i++)
	{
		if(g_iJbTopDistance[i] == 0 || iDistance > g_iJbTopDistance[i])
			break;
		iPlaceInTop++;
	}

	if(iPlaceInTop < 15)
	{
		new szData[512], handle = fopen(g_szJbFile, "wt");	
		for(new j = 14; j > iPlaceInTop; j--)
		{
			g_iJbTopLocalhost[j] = g_iJbTopLocalhost[j-1];
			format(g_szJbTopPlayer[j], charsmax(g_szJbTopPlayer[]), "%s", g_szJbTopPlayer[j-1]);
			g_iJbTopDistance[j] = g_iJbTopDistance[j-1];
			format(g_szJbTopDate[j], charsmax(g_szJbTopDate[]), "%s", g_szJbTopDate[j-1]);
		}

		new curr_time[22]; 
		get_time("%d/%m/%Y", curr_time, charsmax(curr_time)); 
		
		new name[22];
		get_user_name(id, name, charsmax(name));

		if(get_pcvar_num(g_pBugTopShowPlace))
			client_print_f(id, BLUE, "^x04[KZ]^x01 %s's jump is on^x03 %d place^x01 in JumpBug Top!", name, iPlaceInTop + 1);
		
		replace_all(name, charsmax(name), "<", ""); 
		replace_all(name, charsmax(name), ">", "");
		replace_all(name, charsmax(name), "^"", ""); //"
		replace_all(name, charsmax(name), " ", "_");
		replace_all(name, charsmax(name), ";", ""); 		

		g_iJbTopLocalhost[iPlaceInTop] = is_user_localhost(id);
		formatex(g_szJbTopPlayer[iPlaceInTop], charsmax(g_szJbTopPlayer[]), "%s", name);
		g_iJbTopDistance[iPlaceInTop] = iDistance;
		formatex(g_szJbTopDate[iPlaceInTop], charsmax(g_szJbTopDate[]), "%s", curr_time);

		for(new i = 0; (i < 15 && g_iJbTopDistance[i] > 0); i++)
		{
			formatex(szData, charsmax(szData), "%d %s %d %s^n", g_iJbTopLocalhost[i], g_szJbTopPlayer[i], g_iJbTopDistance[i], g_szJbTopDate[i]);
			fputs(handle, szData);
		}

		fclose(handle);
	}
}

public cmdShowEbTop(id)
{
	if(get_pcvar_num(g_pBugTop) == 0)
	{
		client_print_f(id, RED, "^x03[KZ]^x01 Bug Tops are disabled");
		return PLUGIN_HANDLED;
	}

	new buffer[15*122], szPlayerName[22];

	new len = formatex(buffer, charsmax(buffer), "<body bgcolor=#ffffff><table width=100%% cellpadding=2 cellspacing=0 border=0>");
	len += formatex(buffer[len], charsmax(buffer)-len, "<tr align=center bgcolor=#008bdb><th width=5%%> # <th width=35%%> Name <th width=30%%> Distance <th width=30%%> Date ");

	for(new i = 0; (i < 15 && g_iEbTopDistance[i] > 0); i++)
	{
		if(g_iEbTopLocalhost[i])
			formatex(szPlayerName, charsmax(szPlayerName), "<b>%s</b>", g_szEbTopPlayer[i]);
		else
			formatex(szPlayerName, charsmax(szPlayerName), "%s", g_szEbTopPlayer[i]);
		
		len += formatex(buffer[len], charsmax(buffer)-len, "<tr align=center%s><td> %d <td> %s <td> %d units <td> %s", ((i%2)==0) ? "" : " bgcolor=#e2eefa", i+1, szPlayerName, g_iEbTopDistance[i], g_szEbTopDate[i]);
	}

	show_motd(id, buffer, "EdgeBug Top");
	return PLUGIN_HANDLED;
}

public cmdShowJbTop(id)
{
	if(get_pcvar_num(g_pBugTop) == 0)
	{
		client_print_f(id, RED, "^x03[KZ]^x01 Bug Tops are disabled");
		return PLUGIN_HANDLED;
	}

	new buffer[15*122], szPlayerName[22];

	new len = formatex(buffer, charsmax(buffer), "<body bgcolor=#ffffff><table width=100%% cellpadding=2 cellspacing=0 border=0>");
	len += formatex(buffer[len], charsmax(buffer)-len, "<tr align=center bgcolor=#008bdb><th width=5%%> # <th width=35%%> Name <th width=30%%> Distance <th width=30%%> Date ");

	for(new i = 0; (i < 15 && g_iJbTopDistance[i] > 0); i++)
	{
		if(g_iJbTopLocalhost[i])
			formatex(szPlayerName, charsmax(szPlayerName), "<b>%s</b>", g_szJbTopPlayer[i]);
		else
			formatex(szPlayerName, charsmax(szPlayerName), "%s", g_szJbTopPlayer[i]);
		
		len += formatex(buffer[len], charsmax(buffer)-len, "<tr align=center%s><td> %d <td> %s <td> %d units <td> %s", ((i%2)==0) ? "" : " bgcolor=#e2eefa", i+1, szPlayerName, g_iJbTopDistance[i], g_szJbTopDate[i]);
	}

	show_motd(id, buffer, "JumpBug Top");
	return PLUGIN_HANDLED;
}